
#include <stdio.h>
#include <string.h>
#include "xpciapi.h"
#include "xseqbool.h"
#include "xseqpars.h"
#include "yacc_def.h"
#include "xutil.h"
 


extern bx_errtype yaccerr;

extern boolmap * parse_result_ptr;
extern sequencer_descriptor * yy_seq__seq_descr;
extern int yy_seq__syntax_error;
extern int seq_tran_count;
extern bx_handletype BX_GLOBAL_handle;

boolmap * tmp;

int vector_range_lo;
int vector_range_hi;
int seq_state;
int seq_nextstate;

boolmap * yy_seq_boolmap_ptr;
boolmap * current_xcond;

typedef union  { boolmap * boolmap_ptr;
         int token_id;
         int num_value;
         int int_value;
       } YYSTYPE;
#ifdef __cplusplus
#  include <stdio.h>
#  include <yacc.h>
#endif	/* __cplusplus */ 
# define INPUT_VAR 257
# define INPUT_VAR_VECTOR 258
# define CONST_VECTOR 259
# define DECIMAL_NUM 260
# define TRANSIENT_INSTANCE_NAME 261
# define TRANSIENT_STATE 262
# define TRANSIENT_NEXTSTATE 263
# define TRANSIENT_XCOND 264
# define TRANSIENT_OUTPUT 265
# define TRANSIENT_OUTPUT_VECTOR 266
# define LOGICAL_AND 267
# define LOGICAL_OR 268
# define LOGICAL_NOT 269
# define LOGICAL_XOR 270
#define yy_seq_clearin yy_seq_char = -1
#define yy_seq_errok yy_seq_errflag = 0
extern int yy_seq_char;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
YYSTYPE yy_seq_lval;
__YYSCLASS YYSTYPE yy_seq_val;
typedef int yy_seq_tabelem;
# define YYERRCODE 256


/****************************************************************/
/* This function checks the current sequencer state if it is    */
/* within ist range                                             */
/****************************************************************/

int check_seq_state(sd, state)
     sequencer_descriptor * sd;
     int state;
{
   if((state < 0) || (state > sd -> states))
     {
       yaccerr = BX_E_SEQ_TOO_MANY_STATES; /* should NOT happen at all */
       /* because it is caught in the preparation of the parse function */
       /*yy_seq_error("State out of range"); */
       yy_seq__syntax_error = 1;
       return(0);
     }
   else return(state);
          
}

/****************************************************************/
/* This function checks if all transient conditions leaving the */
/* same state are exclusive                                     */
/****************************************************************/

void check_transient_exclusivity(
  sequencer_descriptor * sd
)
{
   int i, chk;
   /* char err_buf[64]; */

   for(i=0; i < sd -> states; i++)
   {
     chk = cmp_boolmap(sd -> default_xcond[i], \
		       sd -> accumul_xcond[i]);
     
     if(chk != 1) 
     {
       yy_seq__syntax_error = 1;
       yaccerr = BX_E_SEQ_TRAN_EXCLUSIVE;
       
       if (BX_GLOBAL_handle!=0xffffffff)
       {
         /*
           BX_GLOBAL_handle is set to handle before calling yy_seq__seq_parse()
           and set to 0xffffffff afterwards. So BX_GLOBAL_handle 
           should have always a correct handle value here, as long
           as we do not work with multiple processes.
         */
         BestXLastErrorParamSet(BX_GLOBAL_handle,BX_ERRPAR_2,i);
       }
       else
       {
         /* Serious error: You should be aware that the CAPI is not
            reentrant. Surely you work with multiple processes here.
            Possible solution: put OS semaphore around the call to
            yy_seq__seq_parse(), if you really need reentrancy here.
         */
       }
       
       /* sprintf(err_buf,"Error: Transients leaving State %d not exclusive", i);
	  yy_seq_error(err_buf);  */
       break; /* leave the loop and this way show the first error */
     }
   }
}

/****************************************************************/
/* This function adds the xfer-condition 'xcond' to the         */
/* sequencer descriptor default xcond and accumulated xcond     */
/* boolmaps                                                     */
/****************************************************************/ 

void add_sequencer_xcond(sd, boolmap_ptr, state)
     sequencer_descriptor * sd;
     boolmap * boolmap_ptr;
     int state;
{
   boolmap * tmp;

   tmp = (boolmap *)add_boolmap(boolmap_ptr, \
                           sd -> accumul_xcond[state]);

   dealloc_boolmap(sd -> accumul_xcond[state]);

   sd -> accumul_xcond[state] = tmp;

   tmp = (boolmap *) or_boolmap(boolmap_ptr, \
                           sd -> default_xcond[state]);

   dealloc_boolmap(sd -> default_xcond[state]);

   sd -> default_xcond[state] = tmp;
}

/****************************************************************/
/* This function adds the given nextstate with its xcond to the */
/* sequencer ram  map                                           */
/****************************************************************/

void add_sequencer_state(sd, state, nextstate, xcond)
     sequencer_descriptor * sd;
     int state;
     int nextstate;
     boolmap * xcond;
{
   int i, j, k, ram_width, addr, addr_offset, s, ld_s;
   int addr1, addr2;
   int stateline_input, stateline_output;
   int index;

   char state_name[8] = "_s0_";

   s      = sd -> states;
   ld_s   = 0;

   while((s & 0x01) == 0)
       {
          s = s >> 1;
          ld_s++;
       }

   ram_width = sd -> outputs + ld_s;

   if(ram_width % 8)
        ram_width = ram_width / 8 + 1;
   else
        ram_width = ram_width / 8;
   
   for(i=0; i < (1 << (sd -> inputs)); i++)   /* for all input vectors */
     {
 
       /* compute the current address of the sequencer ram the output */
       /* bits are written to. Note that the address is formed from   */
       /* both the incremented address i with some fixed interleaved  */
       /* bits representing the current sequencer state               */

       addr = i;       

       for(j=0; j < ld_s; j++)               /* for all input state lines */
           {

            /* look up state line index in token table */

             sprintf(state_name,"_s%d_",j);

             for(k=0; k < ld_s; k++)        
                if(!BESTX_STRCMP(sd -> state_tokenlist[k].tok_name, state_name))
                     index = k;

             stateline_input = sd -> state_tokenlist[index].vectorlen;

             addr1  = ((addr << 1) & ((~0x1) << stateline_input));
             addr2  = (addr & ((0x1 << stateline_input) - 1));
             addr   = addr1 | addr2 | (((state >> j) & 0x01) << stateline_input);
           }

        /* OK, now we have the address and can put the nextstate bits at    */
        /* their proper locations                                           */
     
        for(j=0; j < ld_s; j++)               /* for all output state lines */
           {

            /* look up state line index in token table */

             sprintf(state_name,"_s%d_",j);

             for(k=0; k < ld_s; k++)        
                if(!BESTX_STRCMP(sd -> state_tokenlist[k].tok_name, state_name))
                     index = k;

             stateline_output =  sd -> state_tokenlist[index].position;

             addr_offset =  stateline_output / 8;
             sd -> ram_array_ptr[addr * ram_width + addr_offset] |= \
             (((nextstate >> j) & get_boolmap_bit(xcond, i)) << (stateline_output % 8));

           }
     }   
}

/****************************************************************/
/* This function adds the given output function to the          */
/* sequencer ram  map                                           */
/****************************************************************/

void add_sequencer_output(sd, state, opcond, xcond, op_index)
     sequencer_descriptor * sd;
     int state;
     boolmap * opcond;
     boolmap * xcond;
     int op_index;
{
   int i, j, s, k, ld_s, addr, addr_offset, ram_width;
   int addr1, addr2, stateline_input;
   int index;

   char state_name[8] = "_s0_";

   boolmap * qualified_opcond;

   /* the next couple of lines compute the logarithm dualis of s */
   /* since it is a simple shift, this only works if s is a power*/
   /* of two !                                                   */

   s      = sd -> states;
   ld_s   = 0;

   while((s & 0x01) == 0)
       {
          s = s >> 1;
          ld_s++;
       }

   ram_width = sd -> outputs + ld_s;

   if(ram_width % 8)
        ram_width = ram_width / 8 + 1;
   else
        ram_width = ram_width / 8;
   
   /* form the logical AND of xfer condition and output condition */
   
   qualified_opcond = (boolmap *)and_boolmap(opcond, xcond);
   
   for(i=0; i < (1 << (sd -> inputs)); i++)
     {

       addr = i;       

       /* compute the current address of the sequencer ram the output */
       /* bits are written to. Note that the address is formed from   */
       /* both the incremented address i with some fixed interleaved  */
       /* bits representing the current sequencer state               */

       for(j=0; j < ld_s; j++)               /* for all input state lines */
           {

            /* look up state line index in token table */

             sprintf(state_name,"_s%d_",j);

             for(k=0; k < ld_s; k++)        
                if(!BESTX_STRCMP(sd -> state_tokenlist[k].tok_name, state_name))
                     index = k;

             stateline_input = sd -> state_tokenlist[index].vectorlen;

             addr1  = ((addr << 1) & ((~0x1) << stateline_input));
             addr2  = (addr & ((0x1 << stateline_input) - 1));
             addr   = addr1 | addr2 | (((state >> j) & 0x01) << stateline_input);
           }

        /* OK, now we have the address and can put the output bits at */
        /* their proper locations                                     */

        addr_offset = op_index / 8;
        sd -> ram_array_ptr[addr * ram_width + addr_offset] |= \
        (get_boolmap_bit(qualified_opcond, i) << (op_index % 8));
     }
  
   dealloc_boolmap(qualified_opcond);   
}

/*****************************************************************/
/* This function generates a default transient for each sequencer*/
/* state. This ensures that if no state exit transient is        */
/* specified, the sequencer will remain in the current state     */
/* The default transient xcond is computed as follos:            */
/*   xcond_def(state i) = not( \/ xcond(state i))                */
/*****************************************************************/

void generate_default_transients(sd)
     sequencer_descriptor * sd;
{
   int i;
   boolmap * xcond_def;

   for(i=0; i < sd -> states; i++)
      {
        xcond_def = (boolmap *)not_boolmap(sd -> default_xcond[i]);
        add_sequencer_state(sd, i, i, xcond_def);
	dealloc_boolmap(xcond_def);
      }

}

/*****************************************************************/
/* Function assign_output()                                      */
/* assigns the given sequencer output the given value            */
/*****************************************************************/

void assign_output(sd, state, opcond, xcond, op_index)
    sequencer_descriptor * sd;
    int state;
    boolmap * opcond, * xcond;
    int op_index;
{                  
    add_sequencer_output(sd, state, opcond, current_xcond, op_index);  
    dealloc_boolmap(opcond);
} 

/*****************************************************************/
/* Function assign_output_vector()                               */
/* assigns the given sequencer output the given value            */
/*****************************************************************/

void assign_output_vector(sd, state, vector_value, xcond, op_index, op_vectorlen)
    sequencer_descriptor * sd;
    int state;
    int vector_value;
    boolmap * xcond;
    int op_index;
    int op_vectorlen;
{
    int i;
    boolmap * def0_opcond, * def1_opcond;

    /* generate a default output condition since the sequencer */
    /* syntax does not allow to specify such one               */

    def0_opcond = (boolmap *)alloc_boolmap(xcond -> fcn_vars, 254);
    def1_opcond = (boolmap *)alloc_boolmap(xcond -> fcn_vars, 255);
    
    for(i=0; i < op_vectorlen; i++)
       {  
         if(((vector_value >> i) & 0x01) == 1)                 
                add_sequencer_output(sd, state, def1_opcond, \
                                     current_xcond, op_index + i);
         else
                add_sequencer_output(sd, state, def0_opcond, \
                                     current_xcond, op_index + i);
       }
  
    dealloc_boolmap(def0_opcond);
    dealloc_boolmap(def1_opcond);
} 
__YYSTCLASS yy_seq_tabelem yy_seq_exca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 24
# define YYLAST 232
__YYSTCLASS yy_seq_tabelem yy_seq_act[]={

    47,    36,    30,    37,    37,    17,    38,    23,    24,    14,
    12,     4,    53,    49,    22,    19,    50,    35,    52,    54,
    43,     5,    48,    29,    28,    27,    21,    18,    15,    26,
     9,    25,     3,    42,     6,    20,    10,     7,     2,     8,
     1,    13,    11,    16,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    51,    40,    41,     0,     0,     0,    34,
     0,    44,    45,    46,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    37,    39,     0,    38,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    32,
    33,     0,     0,     0,     0,     0,    37,    39,     0,    38,
     0,    31 };
__YYSTCLASS yy_seq_tabelem yy_seq_pact[]={

  -250, -3000,   -25, -3000, -3000, -3000,  -250,   -28, -3000,  -252,
 -3000,  -254,   -33,  -259,   -34,  -245, -3000,   -35,  -246, -3000,
  -258,   -31, -3000,   -36,   -37, -3000,   -38,   -31,  -242,   -61,
   -38,   -38, -3000,   -71, -3000, -3000, -3000,   -38,   -38,   -38,
   -41, -3000,   -39,  -247, -3000,  -263,  -264, -3000,  -243,   -40,
 -3000, -3000,  -248,   -74, -3000 };
__YYSTCLASS yy_seq_tabelem yy_seq_pgo[]={

     0,    31,    23,    43,    42,    41,    40,    38,    32,    37,
    36,    35,    33 };
__YYSTCLASS yy_seq_tabelem yy_seq_r1[]={

     0,     6,     7,     7,     9,     8,    10,     4,     5,     3,
    11,    11,    11,     1,     2,     2,     2,     2,     2,     2,
     2,    12,    12,    12 };
__YYSTCLASS yy_seq_tabelem yy_seq_r2[]={

     0,     5,     6,     2,     1,     8,     9,     7,     7,     7,
     0,     9,     9,     7,     7,     5,     7,     7,     7,     3,
     9,     0,     7,    11 };
__YYSTCLASS yy_seq_tabelem yy_seq_chk[]={

 -3000,    -6,    -7,    -8,   261,    46,    59,    -9,    -8,    58,
   -10,    -4,   262,    -5,   263,    61,    -3,   264,    61,   260,
   -11,    61,   260,   265,   266,    -1,    60,    61,    61,    -2,
    40,   269,   257,   258,    -1,   259,    62,   267,   270,   268,
    -2,    -2,   -12,    91,    -2,    -2,    -2,    41,    61,   260,
   259,    93,    58,   260,    93 };
__YYSTCLASS yy_seq_tabelem yy_seq_def[]={

     0,    -2,     0,     3,     4,     1,     0,     0,     2,     0,
     5,     0,     0,     0,     0,     0,    10,     0,     0,     7,
     6,     0,     8,     0,     0,     9,     0,     0,     0,     0,
     0,     0,    19,    21,    11,    12,    13,     0,     0,     0,
     0,    15,     0,     0,    16,    17,    18,    14,     0,     0,
    20,    22,     0,     0,    23 };
typedef struct { char *t_name; int t_val; } yy_seq_toktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSTCLASS yy_seq_toktype yy_seq_toks[] =
{
	"INPUT_VAR",	257,
	"INPUT_VAR_VECTOR",	258,
	"CONST_VECTOR",	259,
	"DECIMAL_NUM",	260,
	"TRANSIENT_INSTANCE_NAME",	261,
	"TRANSIENT_STATE",	262,
	"TRANSIENT_NEXTSTATE",	263,
	"TRANSIENT_XCOND",	264,
	"TRANSIENT_OUTPUT",	265,
	"TRANSIENT_OUTPUT_VECTOR",	266,
	"LOGICAL_AND",	267,
	"LOGICAL_OR",	268,
	"LOGICAL_NOT",	269,
	"LOGICAL_XOR",	270,
	"-unknown-",	-1	/* ends search */
};

__YYSTCLASS char * yy_seq_reds[] =
{
	"-no such reduction-",
	"sequence_description : transient_block '.'",
	"transient_block : transient_block ';' transient",
	"transient_block : transient",
	"transient : TRANSIENT_INSTANCE_NAME",
	"transient : TRANSIENT_INSTANCE_NAME ':' transient_body",
	"transient_body : state_assignment nextstate_assignment xcond_assignment output_assignment",
	"state_assignment : TRANSIENT_STATE '=' DECIMAL_NUM",
	"nextstate_assignment : TRANSIENT_NEXTSTATE '=' DECIMAL_NUM",
	"xcond_assignment : TRANSIENT_XCOND '=' condition_expression",
	"output_assignment : /* empty */",
	"output_assignment : output_assignment TRANSIENT_OUTPUT '=' condition_expression",
	"output_assignment : output_assignment TRANSIENT_OUTPUT_VECTOR '=' CONST_VECTOR",
	"condition_expression : '<' condition '>'",
	"condition : '(' condition ')'",
	"condition : LOGICAL_NOT condition",
	"condition : condition LOGICAL_AND condition",
	"condition : condition LOGICAL_XOR condition",
	"condition : condition LOGICAL_OR condition",
	"condition : INPUT_VAR",
	"condition : INPUT_VAR_VECTOR vector_range '=' CONST_VECTOR",
	"vector_range : /* empty */",
	"vector_range : '[' DECIMAL_NUM ']'",
	"vector_range : '[' DECIMAL_NUM ':' DECIMAL_NUM ']'",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 70.7 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#if defined(_AIX)|| defined(AIX)
#include <sys/msgbuf.h>
#else
#include <msgbuf.h>
#endif
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
/* #define YYERROR		goto yy_seq_errlab */

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#if 0
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yy_seq_char >= 0 || ( yy_seq_r2[ yy_seq_tmp ] >> 1 ) != 1 )\
	{\
		yy_seq_error( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto yy_seq_errlab;\
	}\
	yy_seq_char = newtoken;\
	yy_seq_state = *yy_seq_ps;\
	yy_seq_lval = newvalue;\
	goto yy_seq_newstate;\
}
#endif

#define YYRECOVERING()	(!!yy_seq_errflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yy_seq_debug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH
__YYSCLASS YYSTYPE yy_seq_v[ YYMAXDEPTH ];	/* value stack */
__YYSCLASS int yy_seq_s[ YYMAXDEPTH ];		/* state stack */
# else
__YYSCLASS YYSTYPE *yy_seq_v;			/* pointer to malloc'ed value stack */
__YYSCLASS int *yy_seq_s;			/* pointer to malloc'ed stack stack */

#if defined(__STDC__) || defined (__cplusplus)
#include <stdlib.h>
#else
	extern char *BestXMemMalloc();
	extern char *BestXMemRealloc();
	extern void BestXFree();
#endif /* __STDC__ or __cplusplus */


static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  yy_seq_maxdepth ;

__YYSCLASS YYSTYPE *yy_seq_pv;			/* top of value stack */
__YYSCLASS int *yy_seq_ps;			/* top of state stack */

__YYSCLASS int yy_seq_state;			/* current state */
__YYSCLASS int yy_seq_tmp;			/* extra var (lasts between blocks) */

int yy_seq_nerrs;			/* number of errors */
__YYSCLASS int yy_seq_errflag;			/* error recovery flag */
int yy_seq_char;			/* current input token number */



/*
** yy_seq_parse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yy_seq_parse()
{
	register YYSTYPE *yy_seq_pvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yy_seq_parse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	yy_seq_pv = &yy_seq_v[-1];
	yy_seq_ps = &yy_seq_s[-1];
	yy_seq_state = 0;
	yy_seq_tmp = 0;
	yy_seq_nerrs = 0;
	yy_seq_errflag = 0;
	yy_seq_char = -1;

	goto yy_seq_stack;
	{
		register YYSTYPE *yy_seq__pv;	/* top of value stack */
		register int *yy_seq__ps;		/* top of state stack */
		register int yy_seq__state;		/* current state */
		register int  yy_seq__n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
/*	yy_seq_newstate: */
		yy_seq__pv = yy_seq_pv;
		yy_seq__ps = yy_seq_ps;
		yy_seq__state = yy_seq_state;
		goto yy_seq__newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yy_seq_stack:
		yy_seq__pv = yy_seq_pv;
		yy_seq__ps = yy_seq_ps;
		yy_seq__state = yy_seq_state;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_seq__stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yy_seq_debug )
		{
			register int yy_seq__i;

			printf( "State %d, token ", yy_seq__state );
			if ( yy_seq_char == 0 )
				printf( "end-of-file\n" );
			else if ( yy_seq_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_seq__i = 0; yy_seq_toks[yy_seq__i].t_val >= 0;
					yy_seq__i++ )
				{
					if ( yy_seq_toks[yy_seq__i].t_val == yy_seq_char )
						break;
				}
				printf( "%s\n", yy_seq_toks[yy_seq__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_seq__ps >= &yy_seq_s[ yy_seq_maxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			yy_seq_error( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * yy_seq_v_old = yy_seq_v;
			int * yy_seq_s_old = yy_seq_s;
			yy_seq_maxdepth += YYINCREMENT;
			yy_seq_s = (int *) BestXMemRealloc(yy_seq_s, yy_seq_maxdepth * sizeof(int));
			yy_seq_v = (YYSTYPE *) BestXMemRealloc(yy_seq_v, yy_seq_maxdepth * sizeof(YYSTYPE));
			if (yy_seq_s==0 || yy_seq_v==0) {
			    yy_seq_error( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			yy_seq__ps = (yy_seq__ps - yy_seq_s_old) + yy_seq_s;
			yy_seq_ps = (yy_seq_ps - yy_seq_s_old) + yy_seq_s;
			yy_seq__pv = (yy_seq__pv - yy_seq_v_old) + yy_seq_v;
			yy_seq_pv = (yy_seq_pv - yy_seq_v_old) + yy_seq_v;
# endif

		}
		*yy_seq__ps = yy_seq__state;
		*++yy_seq__pv = yy_seq_val;

		/*
		** we have a new state - find out what to do
		*/
	yy_seq__newstate:
		if ( ( yy_seq__n = yy_seq_pact[ yy_seq__state ] ) <= YYFLAG )
			goto yy_seq_default;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yy_seq_tmp = yy_seq_char < 0;
#endif
		if ( ( yy_seq_char < 0 ) && ( ( yy_seq_char = yy_seq_lex() ) < 0 ) )
			yy_seq_char = 0;		/* reached EOF */
#if YYDEBUG
		if ( yy_seq_debug && yy_seq_tmp )
		{
			register int yy_seq__i;

			printf( "Received token " );
			if ( yy_seq_char == 0 )
				printf( "end-of-file\n" );
			else if ( yy_seq_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_seq__i = 0; yy_seq_toks[yy_seq__i].t_val >= 0;
					yy_seq__i++ )
				{
					if ( yy_seq_toks[yy_seq__i].t_val == yy_seq_char )
						break;
				}
				printf( "%s\n", yy_seq_toks[yy_seq__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_seq__n += yy_seq_char ) < 0 ) || ( yy_seq__n >= YYLAST ) )
			goto yy_seq_default;
		if ( yy_seq_chk[ yy_seq__n = yy_seq_act[ yy_seq__n ] ] == yy_seq_char )	/*valid shift*/
		{
			yy_seq_char = -1;
			yy_seq_val = yy_seq_lval;
			yy_seq__state = yy_seq__n;
			if ( yy_seq_errflag > 0 )
				yy_seq_errflag--;
			goto yy_seq__stack;
		}

	yy_seq_default:
		if ( ( yy_seq__n = yy_seq_def[ yy_seq__state ] ) == -2 )
		{
#if YYDEBUG
			yy_seq_tmp = yy_seq_char < 0;
#endif
			if ( ( yy_seq_char < 0 ) && ( ( yy_seq_char = yy_seq_lex() ) < 0 ) )
				yy_seq_char = 0;		/* reached EOF */
#if YYDEBUG
			if ( yy_seq_debug && yy_seq_tmp )
			{
				register int yy_seq__i;

				printf( "Received token " );
				if ( yy_seq_char == 0 )
					printf( "end-of-file\n" );
				else if ( yy_seq_char < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_seq__i = 0;
						yy_seq_toks[yy_seq__i].t_val >= 0;
						yy_seq__i++ )
					{
						if ( yy_seq_toks[yy_seq__i].t_val
							== yy_seq_char )
						{
							break;
						}
					}
					printf( "%s\n", yy_seq_toks[yy_seq__i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
			/*	register int *yy_seq_xi = yy_seq_exca; */
                                const int *yy_seq_xi = yy_seq_exca;

				while ( ( *yy_seq_xi != -1 ) ||
					( yy_seq_xi[1] != yy_seq__state ) )
				{
					yy_seq_xi += 2;
				}
				while ( ( *(yy_seq_xi += 2) >= 0 ) &&
					( *yy_seq_xi != yy_seq_char ) )
					;
				if ( ( yy_seq__n = yy_seq_xi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_seq__n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yy_seq_errflag )
			{
			case 0:		/* new error */
				yy_seq_error( (nl_msg(30003,"syntax error")) );
				yy_seq_nerrs++;
				goto skip_init;
		/*	yy_seq_errlab: */
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_seq__pv = yy_seq_pv;
				yy_seq__ps = yy_seq_ps;
				yy_seq__state = yy_seq_state;
				yy_seq_nerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yy_seq_errflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_seq__ps >= yy_seq_s )
				{
					yy_seq__n = yy_seq_pact[ *yy_seq__ps ] + YYERRCODE;
					if ( yy_seq__n >= 0 && yy_seq__n < YYLAST &&
						yy_seq_chk[yy_seq_act[yy_seq__n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_seq__state = yy_seq_act[ yy_seq__n ];
						goto yy_seq__stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yy_seq_debug )
						printf( _POP_, *yy_seq__ps,
							yy_seq__ps[-1] );
#	undef _POP_
#endif
					yy_seq__ps--;
					yy_seq__pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yy_seq_debug )
				{
					register int yy_seq__i;

					printf( "Error recovery discards " );
					if ( yy_seq_char == 0 )
						printf( "token end-of-file\n" );
					else if ( yy_seq_char < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_seq__i = 0;
							yy_seq_toks[yy_seq__i].t_val >= 0;
							yy_seq__i++ )
						{
							if ( yy_seq_toks[yy_seq__i].t_val
								== yy_seq_char )
							{
								break;
							}
						}
						printf( "token %s\n",
							yy_seq_toks[yy_seq__i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yy_seq_char == 0 )	/* reached EOF. quit */
					YYABORT;
				yy_seq_char = -1;
				goto yy_seq__newstate;
			}
		}/* end if ( yy_seq__n == 0 ) */
		/*
		** reduction by production yy_seq__n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yy_seq_debug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_seq__n, yy_seq_reds[ yy_seq__n ] );
#endif
		yy_seq_tmp = yy_seq__n;			/* value to switch over */
		yy_seq_pvt = yy_seq__pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_seq__state here as temporary
		** register variable, but why not, if it works...
		** If yy_seq_r2[ yy_seq__n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_seq__stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_seq__len = yy_seq_r2[ yy_seq__n ];

			if ( !( yy_seq__len & 01 ) )
			{
				yy_seq__len >>= 1;
				yy_seq_val = ( yy_seq__pv -= yy_seq__len )[1];	/* $$ = $1 */
				yy_seq__state = yy_seq_pgo[ yy_seq__n = yy_seq_r1[ yy_seq__n ] ] +
					*( yy_seq__ps -= yy_seq__len ) + 1;
				if ( yy_seq__state >= YYLAST ||
					yy_seq_chk[ yy_seq__state =
					yy_seq_act[ yy_seq__state ] ] != -yy_seq__n )
				{
					yy_seq__state = yy_seq_act[ yy_seq_pgo[ yy_seq__n ] ];
				}
				goto yy_seq__stack;
			}
			yy_seq__len >>= 1;
			yy_seq_val = ( yy_seq__pv -= yy_seq__len )[1];	/* $$ = $1 */
			yy_seq__state = yy_seq_pgo[ yy_seq__n = yy_seq_r1[ yy_seq__n ] ] +
				*( yy_seq__ps -= yy_seq__len ) + 1;
			if ( yy_seq__state >= YYLAST ||
				yy_seq_chk[ yy_seq__state = yy_seq_act[ yy_seq__state ] ] != -yy_seq__n )
			{
				yy_seq__state = yy_seq_act[ yy_seq_pgo[ yy_seq__n ] ];
			}
		}
					/* save until reenter driver code */
		yy_seq_state = yy_seq__state;
		yy_seq_ps = yy_seq__ps;
		yy_seq_pv = yy_seq__pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yy_seq_tmp )
	{
		
case 1:{ generate_default_transients(yy_seq__seq_descr);  check_transient_exclusivity(yy_seq__seq_descr); } break;
case 4:{seq_tran_count++;} break;
case 6:{ dealloc_boolmap(yy_seq_pvt[-1].boolmap_ptr); } break;
case 7:{ seq_state = check_seq_state(yy_seq__seq_descr, yy_seq_pvt[-0].int_value); } break;
case 8:{ seq_nextstate = check_seq_state(yy_seq__seq_descr, yy_seq_pvt[-0].int_value); } break;
case 9:{ yy_seq_val.boolmap_ptr = yy_seq_pvt[-0].boolmap_ptr; current_xcond = yy_seq_pvt[-0].boolmap_ptr;  add_sequencer_xcond(yy_seq__seq_descr, yy_seq_pvt[-0].boolmap_ptr, seq_state); add_sequencer_state(yy_seq__seq_descr, seq_state, seq_nextstate, yy_seq_pvt[-0].boolmap_ptr);} break;
case 11:{ assign_output(yy_seq__seq_descr, seq_state, yy_seq_pvt[-0].boolmap_ptr, current_xcond, (yy_seq_pvt[-2].token_id & 0xFF));} break;
case 12:{ assign_output_vector(yy_seq__seq_descr, seq_state, yy_seq_pvt[-0].num_value, current_xcond, (yy_seq_pvt[-2].token_id & 0xFF), (yy_seq_pvt[-2].token_id & 0xFF00) >> 8); } break;
case 13:{ yy_seq_val.boolmap_ptr = yy_seq_pvt[-1].boolmap_ptr; } break;
case 14:{ yy_seq_val.boolmap_ptr = yy_seq_pvt[-1].boolmap_ptr; } break;
case 15:{ yy_seq_val.boolmap_ptr = (boolmap *)not_boolmap(yy_seq_pvt[-0].boolmap_ptr);    dealloc_boolmap(yy_seq_pvt[-0].boolmap_ptr); } break;
case 16:{ yy_seq_val.boolmap_ptr = (boolmap *)and_boolmap(yy_seq_pvt[-2].boolmap_ptr,yy_seq_pvt[-0].boolmap_ptr); dealloc_boolmap(yy_seq_pvt[-2].boolmap_ptr); dealloc_boolmap(yy_seq_pvt[-0].boolmap_ptr); } break;
case 17:{ yy_seq_val.boolmap_ptr = (boolmap *)xor_boolmap(yy_seq_pvt[-2].boolmap_ptr,yy_seq_pvt[-0].boolmap_ptr); dealloc_boolmap(yy_seq_pvt[-2].boolmap_ptr); dealloc_boolmap(yy_seq_pvt[-0].boolmap_ptr); } break;
case 18:{ yy_seq_val.boolmap_ptr = (boolmap *) or_boolmap(yy_seq_pvt[-2].boolmap_ptr,yy_seq_pvt[-0].boolmap_ptr); dealloc_boolmap(yy_seq_pvt[-2].boolmap_ptr); dealloc_boolmap(yy_seq_pvt[-0].boolmap_ptr); } break;
case 19:{ yy_seq_val.boolmap_ptr = (boolmap *)alloc_boolmap((yy_seq_pvt[-0].token_id & 0xFF00) >> 8,yy_seq_pvt[-0].token_id & 0xFF);    } break;
case 20:{ yy_seq_val.boolmap_ptr = (boolmap *)alloc_boolmap((yy_seq_pvt[-3].token_id & 0xFF00) >> 8,yy_seq_pvt[-3].token_id & 0xFF); } break;
case 22:{ vector_range_hi = yy_seq_pvt[-1].int_value; vector_range_lo = yy_seq_pvt[-1].int_value; } break;
case 23:{ vector_range_hi = yy_seq_pvt[-3].int_value; vector_range_lo = yy_seq_pvt[-1].int_value; } break;
	}
	goto yy_seq_stack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the yy_seq_s and yy_seq_v stacks */
	yy_seq_s = (int *) BestXMemMalloc(yy_seq_maxdepth * sizeof(int));
	yy_seq_v = (YYSTYPE *) BestXMemMalloc(yy_seq_maxdepth * sizeof(YYSTYPE));

	if (yy_seq_s==0 || yy_seq_v==0) {
	   yy_seq_error( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (yy_seq_s!=0) BestXFree((char *) yy_seq_s);
	if (yy_seq_v!=0) BestXFree((char *) yy_seq_v);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

